


/**************** env *****************/



action_define!{EnvHeight, 0x0701, 
    ActLv::ANY, false, [], {},
    (self, ctx, _gas {
        Ok(ctx.env().block.height.to_be_bytes().to_vec())
    })
}


action_define!{EnvMainAddr, 0x0702, 
    ActLv::ANY, false, [], {},
    (self, ctx, _gas {
        Ok(ctx.env().tx.main.to_vec())
    })
}


action_define!{EnvCoinbaseAddr, 0x0703, 
    ActLv::ANY, false, [], {},
    (self, ctx, _gas {
        let cbadr = ctx.env().block.coinbase.clone();
        Ok(cbadr.to_vec())
    })
}



/**************** func *****************/



action_define!{FuncCheckSign, 0x0601, 
    ActLv::ANY, false, [], {
        addr: Address
    },
    (self, ctx, _gas {
        match ctx.check_sign(&self.addr) {
            Ok(..) => Ok(vec![1]), // yes
            _ => Ok(vec![0]) // no
        }
    })
}


action_define!{FuncHacToZhu, 0x0602, 
    ActLv::ANY, false, [], {
        hacash: Amount
    },
    (self, ctx, _gas {
        let Some(zhu) = self.hacash.to_zhu_u64() else {
            return errf!("call FuncHacToZhu overflow")
        };
        Ok(zhu.to_be_bytes().to_vec())
    })
}


action_define!{FuncDiamondInscNum, 0x0603, 
    ActLv::ANY, false, [], {
        diamond: DiamondName
    },
    (self, ctx, _gas {
        let Some(diaobj) = CoreStateRead::wrap(ctx.state()).diamond(&self.diamond) else {
            return errf!("diamond {} not find", self.diamond.to_readable())
        };
        let num = diaobj.inscripts.length();
        if num > u8::MAX as usize {
            return errf!("diamond {} inscripts number error", self.diamond.to_readable())
        }
        // ok
        Ok(vec![num as u8])
    })
}


action_define!{FuncDiamondInscGet, 0x0604, 
    ActLv::ANY, false, [], {
        diamond: DiamondName
        inscidx: Uint1
    },
    (self, ctx, _gas {
        let Some(diaobj) = CoreStateRead::wrap(ctx.state()).diamond(&self.diamond) else {
            return errf!("diamond {} not find", self.diamond.to_readable())
        };
        let num = diaobj.inscripts.length();
        let idx = self.inscidx.uint() as usize ;
        if idx >= num {
            return errf!("diamond {} inscripts number overflow", self.diamond.to_readable())
        }
        let insc = &diaobj.inscripts.list()[idx];
        // ok
        Ok(insc.to_vec())
    })
}

