use sys::*;


pub mod util;
pub mod action;
pub mod hook;



const NODE_VERSION: &str    = "0.1.0";
const NODE_BUILD_TIME: &str = "2025/06/06(1)";
const STATE_DB_UPDT: u32    = 1;



fn main() {

    protocol::action::setup_extend_actions_try_create(2, action::try_create);
    protocol::action::setup_action_hook(hook::try_action_hook);
    server::extend::setup_extend_api_routes(hook::extend_api_routes);

    println!("[Version] hachvm  v{}, build time: {}, database type: {}.", 
        NODE_VERSION, NODE_BUILD_TIME, STATE_DB_UPDT
    );

    let cnfp = "./hachvm.config.ini".to_string();
    let inicnf = load_config(cnfp);

    hacash::fullnode_with_ini(inicnf)

}
