
#[macro_export]
macro_rules! deploy_contract {
    (
        $accpswd: expr, $nonce:expr, ( $( $systy:expr, $scdty:expr, $syscds:expr ),* ), ( $( $usrname:ident, $ucdty:expr, $usrcds:expr),* )
    ) => { {
        
        use Bytecode::*;
        use SystemCall::*;

        let acc = Account::create_by($accpswd).unwrap();
        let mut csto = ContractSto::new();
        $({
            let mut syscal = ContractSystemCall::new();
            syscal.sign = Fixed1::from([$systy as u8]); // PermitHAC or ...
            syscal.cdty = Fixed1::from([$scdty]);
            try_compile_check(CodeType::parse($scdty).unwrap(), &$syscds).unwrap();
            syscal.code = BytesW2::from($syscds).unwrap();
            csto.sytmcalls.push(syscal).unwrap();
        })*
        $({
            let mut usrfun = ContractClientFunc::new();
            usrfun.sign = Fixed4::from(calc_func_sign(stringify!($usrname)));
            usrfun.cdty = Fixed1::from([$ucdty]);
            try_compile_check(CodeType::parse($ucdty).unwrap(), &$usrcds).unwrap();
            usrfun.code = BytesW2::from($usrcds).unwrap();
            csto.userfuncs.push(usrfun).unwrap();
        })*
        let mut act2 = ContractDeploy::new();
        act2.nonce = Uint4::from($nonce);
        act2.contract = csto;
        act2.protocol_fee = Amount::coin(6, 245);
        // print
        print_curl_trs(&acc, vec![Box::new(act2)])
    }}
}



#[cfg(test)]
mod test {
    use super::*;
    use vm::ir::*;
    use vm::rt::*;
    use crate::action::*;
    #[test]
    fn test1() {
        use Bytecode::*;

        let irnodes = build_codes!(
            ALLOC 2 MOVE 1 XOP 0 P1 IRIF XLG 0b01000000 P0 ABT XOP 0b01000000 P1 PUTX 0 CU32 GETX 0 PUTX 1 EXTENV 2 IRWHILE NEQ GETX 0 PU8 30 IRBLOCK 0 2 IRIF NOT EXTFUNC 1 ADD PU8 5 MUL GETX 1 PU8 3 ABT PUTX 1 EXTENV 1 PUTX 0 ADD GETX 0 P1 IRIF LE GETX 0 PU8 9 IRBLOCK 0 2 AST GT GETX 1 P1 PUTX 0 ADD GETX 0 P1 NOP RET MOD GETX 0 PU16 0 8
        );
        println!("\n{}, len: {}\n", irnodes.hex(), irnodes.len());
        println!("\n{}\n", irnodes.irnode_print(false).unwrap());
        println!("\n{}\n", irnodes.irnode_print(true).unwrap());
        let domul3 = compile_irs_to_bytecodes(&irnodes).unwrap();
        println!("\n{}, len: {}\n", domul3.hex(), domul3.len());
        println!("\n{}\n", domul3.bytecode_print(false).unwrap());
        println!("\n{}\n", domul3.bytecode_print(true).unwrap());

        // PUTX 0 ADD GETX 0 P1   =   LOCXOP * P1 = 8*32
        //  ALLOC 2 PUTM0 GETX 0 CU32 PUTX 0 PU8 9 GETX 0 LT BRSL 0 4 NOP JMPSL 0 6 P1 GETX 0 ADD PUTX 0 GETX 0 RET
        /*
        domul3 = build_codes!(
            CU32 DUP PU8 9 LT BRS 2 P1 ADD RET 
        );
        */

        deploy_contract!{ "123456", 0, (
            PermitHAC, 0, build_codes!(P0 RET),
            PayableHAC,0, build_codes!(P1 RET)
        ), (
            testadd, 0b10000000, build_codes!(ALLOC 5 CU16 P1 ADD RET),
            domul3,  0b10000001, irnodes
        )};
    }

}
