

#[allow(dead_code)]
fn print_curl_trs(acc: &Account, acts: Vec<Box<dyn Action>>) -> String {

    // let acc = Account::create_by_password("123456").unwrap();
    let addr = Address::from(*acc.address());
    
    let fee = Amount::small(2, 245);

    let mut trs = TransactionType3::new_by(addr, fee);
    
    for act in acts {
        trs.push_action(act).unwrap();
    }

    trs.gas_max = Uint1::from(10);
    trs.fill_sign(&acc).unwrap();

    let dpurl = format!(r#"curl "http://127.0.0.1:8088/submit/transaction?hexbody=true" -X POST -d "{}""#, trs.serialize().hex());
    
    // print
    println!("\n\n");
    println!("{}", dpurl);
    println!("\n");
    
    dpurl
}
