use value::Value;



#[allow(dead_code)]
pub struct MachineBox {
    pub machine: Option<Machine>
} 

impl Drop for MachineBox {
    fn drop(&mut self) {
        // println!("\n---------------\n[MachineBox Drop] Reclaim resoure))\n---------------\n");
        let m = self.machine.take().unwrap();
        MACHINE_MANAGER.reclaim(m.remove());
    }
}

impl MachineBox {
    pub fn new(m: Machine) -> Self {
        Self { 
            machine: Some(m)
        }
    }
}

impl VMI for MachineBox {
    fn usable(&self) -> bool { true }
    fn call(&mut self, ctx: &mut dyn Context, sta: &mut dyn State, ty: u8, kd: u8, data: &[u8], param: Vec<u8>) -> Ret<Vec<u8>> {
        // gas &&  check balance
        let gas_limit = SpaceCap::new(ctx.env().block.height).max_gas_of_tx as i64;
        let mut gas = ctx.tx().size() as i64;
        let (feer, gasfee) = ctx.tx().fee_extend()?;
        if feer == 0 {
            return errf!("gas extend cannot empty on contract call")
        }
        let main = ctx.env().tx.main;
        protocol::operate::hac_check(ctx, &main, &gasfee)?;
        gas *= feer as i64;
        if gas > gas_limit {
            gas = gas_limit; // max 65535
        }
        let gas = &mut gas;
        // env
        let sta = &mut VMState::wrap(sta);
        let exenv = &mut ExecEnv{ ctx, sta, gas };
        let cty: CallTy = std_mem_transmute!(ty);
        match cty {
            CallTy::Main => {
                let cty = CodeType::parse(kd).map_err(|e|e.to_string())?;
                self.machine.as_mut().unwrap().main_call(exenv, cty, data.to_vec())
            },
            CallTy::System => {
                let kid: SystemCall = std_mem_transmute!(kd);
                let cadr = ContractAddress::parse(data)?;
                self.machine.as_mut().unwrap().sysm_call(exenv, kid, cadr, param)
            }
        }.map(|a|a.to_bytes())

    }
}




/*********************************/





#[allow(dead_code)]
pub struct Machine {
    r: Resoure,
    frames: CallFrame,
}



impl Machine {

    pub fn create(r: Resoure) -> Self {
        Self {
            r,
            frames: CallFrame::new(),
        }
    }

    pub fn remove(mut self) -> Resoure {
        self.frames.reclaim(&mut self.r);
        self.r
    }

    pub fn main_call(&mut self, env: &mut ExecEnv, ctype: CodeType, codes: Vec<u8>) -> Ret<Value> {
        let fnobj = FnObj{confs: 0, ctype, codes};
        self.do_call(env, CallMode::Main, fnobj, None).map_err(|e|e.to_string())
    }

    pub fn sysm_call(&mut self, env: &mut ExecEnv, syscty: SystemCall, contract_addr: ContractAddress, param: Vec<u8>) -> Ret<Value> {
        let Some(fnobj) = self.r.load_system(env.sta, &contract_addr, syscty).map_err(|e|e.to_string())? else {
            return Ok(Value::Nil) // not find call
        };
        self.do_call(env, CallMode::System, fnobj.as_ref().clone(), Some(Value::bytes(param))).map_err(|e|e.to_string())
    }

    fn do_call(&mut self, env: &mut ExecEnv, mode: CallMode, code: FnObj, param: Option<Value>) -> VmrtRes<Value> {
        self.frames.start_call(&mut self.r, env, mode, code, param)
    }

}




